//Mifare Classic Driver
//(C) TechnicallyObsolete 2025
#ifndef TAG_MIFARE_CLASSIC_H
#define TAG_MIFARE_CLASSIC_H

#include <stdint.h>

#include "rfid_generic.h"
#include "mifare_crypto1.h"

#define TAG_MIFARE_CLASSIC_TEMP_BUF_SIZE 18

#ifndef TAG_MIFARE_CLASSIC_LOG_CTX
  #define TAG_MIFARE_CLASSIC_LOG_CTX NULL
#endif

typedef enum {
  TAG_MIFARE_CLASSIC_KEY_A = 0,
  TAG_MIFARE_CLASSIC_KEY_B = 1
} tagMifareClassic_key_e;

typedef enum {
  TAG_MIFARE_CLASSIC_VALUE_OP_DEC = 0,
  TAG_MIFARE_CLASSIC_VALUE_OP_INC = 1,
  TAG_MIFARE_CLASSIC_VALUE_OP_RESTORE = 2,
  TAG_MIFARE_CLASSIC_VALUE_OP_TRANSFER = 3
} tagMifareClassic_valueOp_e;


typedef enum {
  TAG_MIFARE_CLASSIC_TYPE_1K = 0,
  TAG_MIFARE_CLASSIC_TYPE_2K = 1,
  TAG_MIFARE_CLASSIC_TYPE_4K = 2,
  TAG_MIFARE_CLASSIC_TYPE_PLUS_2K = 3,
  TAG_MIFARE_CLASSIC_TYPE_PLUS_4K = 4,
} tagMifareClassic_type_e;

#define TAG_MIFARE_CLASSIC_CMD_AUTH_A   0x60
#define TAG_MIFARE_CLASSIC_CMD_AUTH_B   0x61

#define TAG_MIFARE_CLASSIC_CMD_READ     0x30
#define TAG_MIFARE_CLASSIC_CMD_WRITE    0xA0
#define TAG_MIFARE_CLASSIC_CMD_DEC      0xC0
#define TAG_MIFARE_CLASSIC_CMD_INC      0xC1
#define TAG_MIFARE_CLASSIC_CMD_RESTORE  0xC2
#define TAG_MIFARE_CLASSIC_CMD_TRANSFER 0xB0
#define TAG_MIFARE_CLASSIC_CMD_HALT     0x50

typedef struct {
  mifareCrypto1_ctx_t crypto1Ctx;

  uint16_t temp[TAG_MIFARE_CLASSIC_TEMP_BUF_SIZE];

  void * readerCtx;
  rfidGeneric_fn_sendFrameWaitForReplyExtParity_t sendFrameWaitForReplyExtParity;
} tagMifareClassic_ctx_t;

int tagMifareClassic_init(tagMifareClassic_ctx_t *ctx, void * readerCtx, rfidGeneric_fn_sendFrameWaitForReplyExtParity_t sendFrameWaitForReplyExtParity);

int tagMifareClassic_authBlock(tagMifareClassic_ctx_t *ctx, uint64_t key, tagMifareClassic_key_e keyAB, uint32_t uid, uint32_t readerChallenge, uint8_t blockAddr);

int tagMifareClassic_blockRead(tagMifareClassic_ctx_t *ctx, uint8_t blockAddr, uint8_t out[16]);

//"safe" block read,
// won't write to any of the key / auth locations
int tagMifareClassic_safeBlockWrite(tagMifareClassic_ctx_t *ctx, uint8_t blockAddr, uint8_t const in[16]);

int tagMifareClassic_valueRead(tagMifareClassic_ctx_t *ctx, uint8_t blockAddr, uint32_t *value);
int tagMifareClassic_valueChange(tagMifareClassic_ctx_t *ctx, uint8_t blockAddr, tagMifareClassic_valueOp_e op, uint32_t value);

int tagMifareClassic_halt(tagMifareClassic_ctx_t *ctx, bool isAuthenticated);


#endif //TAG_MIFARE_CLASSIC_H
