//Generic RFID abstraction layer
//(C) TechnicallyObsolete 2020, 2021, 2022, 2025

#ifndef RFID_GENERIC_H
#define RFID_GENERIC_H


#include <stdint.h>
#include <stdbool.h>
typedef enum {
  RFID_GENERIC_PROTO_OFF = 0,
  RFID_GENERIC_PROTO_ISO15693 = 1,
  RFID_GENERIC_PROTO_ISO14443A = 2,
  RFID_GENERIC_PROTO_ISO14443B = 3,
  RFID_GENERIC_PROTO_ISO18092 = 4,
  RFID_GENERIC_PROTO_PICOPASS = 5
} rfidGeneric_protocol_e;



#define RFID_GENERIC_FLAG_SPLIT_FULL (0 << 0)
#define RFID_GENERIC_FLAG_SPLIT_1B   (1 << 0)
#define RFID_GENERIC_FLAG_SPLIT_2B   (2 << 0)
#define RFID_GENERIC_FLAG_SPLIT_3B   (3 << 0)
#define RFID_GENERIC_FLAG_SPLIT_4B   (4 << 0)
#define RFID_GENERIC_FLAG_SPLIT_5B   (5 << 0)
#define RFID_GENERIC_FLAG_SPLIT_6B   (6 << 0)
#define RFID_GENERIC_FLAG_SPLIT_7B   (7 << 0)
#define RFID_GENERIC_FLAG_SPLIT_MASK (7 << 0)

#define RFID_GENERIC_FLAG_NO_CRC_TX   (1 << 3)
#define RFID_GENERIC_FLAG_NO_CRC_RX   (1 << 4)
#define RFID_GENERIC_FLAG_NO_REPLY    (1 << 5)
#define RFID_GENERIC_FLAG_NO_RETRY    (1 << 6)
#define RFID_GENERIC_FLAG_NO_DATA     (1 << 7) //Check for SOF only (used by PicoPass)
#define RFID_GENERIC_FLAG_ISO_14443P4 (1 << 8)
#define RFID_GENERIC_FLAG_NO_PARITY   (1 << 9) //If set, each frame 
#define RFID_GENERIC_FLAG_SPLIT_RX    (1 << 10) //If set, each frame 

#define RFID_GENERIC_FLAG_CARD_SEL_POS    (12)
#define RFID_GENERIC_FLAG_CARD_SEL_MASK   (0xF << RFID_GENERIC_FLAG_CARD_SEL_POS)

#define RFID_GENERIC_STS_SPLIT_FULL (0 << 0)
#define RFID_GENERIC_STS_SPLIT_1B   (1 << 0)
#define RFID_GENERIC_STS_SPLIT_2B   (2 << 0)
#define RFID_GENERIC_STS_SPLIT_3B   (3 << 0)
#define RFID_GENERIC_STS_SPLIT_4B   (4 << 0)
#define RFID_GENERIC_STS_SPLIT_5B   (5 << 0)
#define RFID_GENERIC_STS_SPLIT_6B   (6 << 0)
#define RFID_GENERIC_STS_SPLIT_7B   (7 << 0)
#define RFID_GENERIC_STS_SPLIT_MASK (7 << 0)

#define RFID_GENERIC_STS_COLLISION  (1 << 8)


#define RFID_GENERIC_STS_COLLISION_POS        (16)
#define RFID_GENERIC_STS_COLLISION_MASK    (0xFF << RFID_GENERIC_STS_COLLISION_POS)


typedef int (*rfidGeneric_fn_init_t) (void * ctx, rfidGeneric_protocol_e protocol);
typedef int (*rfidGeneric_fn_sendFrameWaitForReply_t) (void * ctx, uint32_t flags, uint8_t const * sendBuf, uint_least16_t sendBufLen, uint8_t *recvBuf, uint_least16_t recvBufLen, uint32_t  *recvSts);
typedef int (*rfidGeneric_fn_sendFrameWaitForReplyExtParity_t) (void * ctx, uint32_t flags, uint16_t const * sendBuf, uint_least16_t sendBufLen, uint16_t *recvBuf, uint_least16_t recvBufLen, uint32_t *recvSts);
typedef int (*rfidGeneric_fn_sendEof_t) (void * ctx, uint8_t *recvBuf, uint_least16_t recvBufLen, int32_t *collisionPos);
typedef int (*rfidGeneric_fn_setFieldPower_t) (void * ctx, bool fieldOn);

typedef struct {
  rfidGeneric_fn_init_t init;
  rfidGeneric_fn_sendFrameWaitForReply_t sendFrameWaitForReply;
  rfidGeneric_fn_sendFrameWaitForReplyExtParity_t sendFrameWaitForReplyExtParity;
  rfidGeneric_fn_sendEof_t sendEof;
  rfidGeneric_fn_setFieldPower_t setFieldPower;

} rfidGeneric_fnPtr_t;



#endif //RFID_GENERIC_H
