//Mifare Classic Driver
//(C) TechnicallyObsolete 2019, 2025
#ifndef MIFARE_CRYPTO1_H
#define MIFARE_CRYPTO1_H

#include <stdint.h>

#ifndef MIFARE_CRYPTO1_LOG_CTX
  #define MIFARE_CRYPTO1_LOG_CTX NULL
#endif

typedef enum {
  MIFARE_CRYPTO1_FBTYPE_NONE      = 0,
  MIFARE_CRYPTO1_FBTYPE_LINEAR    = 1,
  MIFARE_CRYPTO1_FBTYPE_NONLINEAR = 2,
  MIFARE_CRYPTO1_FBTYPE_BOTH      = 3
} mifareCrypto1_fbtype_e;

typedef struct {
  uint64_t lfsr; //LFSR is actually 48 bits

  //Authentication logic
  uint32_t tagChallenge;
  uint32_t readerChallenge;

  //ks don't really need to be part of the struct,
  // but it makes debugging (and unit testing) the auth process much easier
  uint32_t ks[2];
 } mifareCrypto1_ctx_t;


//The following functions should be used for updating the keystream only,
// not performing encryption / decryption
int mifareCrypto1_updateKeystreamWord(mifareCrypto1_ctx_t *ctx, uint32_t wordIn, uint32_t *wordOut, mifareCrypto1_fbtype_e fb);
int mifareCrypto1_updateKeystreamByte(mifareCrypto1_ctx_t *ctx, uint8_t byteIn, uint8_t *byteOut, mifareCrypto1_fbtype_e fb);

//These functions do encrypt/decrypt
int mifareCrypto1_cryptWord(mifareCrypto1_ctx_t *ctx, uint32_t wordIn, uint32_t *wordOut, mifareCrypto1_fbtype_e fb);
int mifareCrypto1_cryptByte(mifareCrypto1_ctx_t *ctx, uint8_t byteIn, uint8_t *byteOut, uint8_t *parityOut, mifareCrypto1_fbtype_e fb);
int mifareCrypto1_cryptByteOut16b(mifareCrypto1_ctx_t *ctx, uint8_t byteIn, uint16_t *byteOut, mifareCrypto1_fbtype_e fb);
int mifareCrypto1_calcParityBit(mifareCrypto1_ctx_t *ctx, uint8_t in);

int mifareCrypto1_authReaderInit(mifareCrypto1_ctx_t *ctx, uint64_t key, uint32_t uid, uint32_t tagChallenge, uint32_t readerChallenge, uint16_t dataOut[8]);
int mifareCrypto1_authReaderHandleTagReply(mifareCrypto1_ctx_t *ctx, uint32_t tagReply);


//Private functions
uint32_t mifareCrypto1_byteSwap32(uint32_t in);
uint64_t mifareCrypto1_endianSwap48(uint64_t in);
int mifareCrypto1_generateFbBitNonLinear(uint64_t in);
int mifareCrypto1_generateFbBitLinear(uint64_t in);
int mifareCrypto1_round(mifareCrypto1_ctx_t *ctx, int in, mifareCrypto1_fbtype_e fb);
uint32_t mifareCrypto1_suc(uint32_t in, uint_least16_t steps);
#endif //MIFARE_CRYPTO1_H
