//CR95HF RFID driver
//(C) TechnicallyObsolete 2019, 2025
#ifndef CR95HF_H
#define CR95HF_H

#include <stdint.h>
#include <stdbool.h>

#include "rfid_generic.h"

#define CR95HF_TEMP_BUF_SIZE 64
#ifndef CR95HF_LOG_CTX
  #define CR95HF_LOG_CTX NULL
#endif

typedef struct {
  rfidGeneric_protocol_e protocol;
  uint32_t id;
  int defaultRetryCount;
  bool isUart;
  bool customTiming;
  uint8_t pp;
  uint8_t mm;
  uint8_t dd;

  uint8_t tempBuf[CR95HF_TEMP_BUF_SIZE];
} cr95hf_ctx_t;


//LL interface
int cr95hf_ll_init(cr95hf_ctx_t *ctx);
int cr95hf_ll_csLow(cr95hf_ctx_t *ctx);
int cr95hf_ll_csHigh(cr95hf_ctx_t *ctx);
int cr95hf_ll_tx(cr95hf_ctx_t *ctx, uint8_t const *data, uint_least16_t len);
int cr95hf_ll_rx(cr95hf_ctx_t *ctx, uint8_t *data, uint_least16_t maxLen);

//Main interface
int cr95hf_waitUntilReady(cr95hf_ctx_t *ctx, uint8_t mask, int maxTries);

int cr95hf_getReply(cr95hf_ctx_t *ctx, uint8_t *replyBuf, uint_least16_t maxReplyLen, uint8_t *returnCode);
int cr95hf_sendCmdWaitForReply(cr95hf_ctx_t *ctx, uint8_t cmd, uint8_t const *data, uint_least16_t dataLen, uint8_t *replyBuf, uint_least16_t maxReplyLen, uint8_t *returnCode, bool appendFlags, uint8_t flags);
int cr95hf_sendCmdWaitForReplyRetry(cr95hf_ctx_t *ctx, uint8_t cmd, uint8_t const *data, uint_least16_t dataLen, uint8_t *replyBuf, uint_least16_t maxReplyLen, uint8_t *returnCode, unsigned int retry, bool appendFlags, uint8_t flags);

int cr95hf_sendCmdNoWaitReply(cr95hf_ctx_t *ctx, uint8_t cmd, uint8_t const *data, uint8_t dataLen, bool appendFlags, uint8_t flags);

int cr95hf_init(cr95hf_ctx_t *ctx, rfidGeneric_protocol_e protocol);
int cr95hf_rfSendFrameWaitForReply(cr95hf_ctx_t *ctx, uint32_t flags, uint8_t const * sendBuf, uint_least16_t sendBufLen, uint8_t *recvBuf, uint_least16_t recvBufLen, uint32_t *recvSts);
int cr95hf_rfSendFrameWaitForReplyExtParity(cr95hf_ctx_t *ctx, uint32_t flags, uint16_t const * sendBuf, uint_least16_t sendBufLen, uint16_t *recvBuf, uint_least16_t recvBufLen, uint32_t *recvSts);

int cr95hf_setFieldPower(cr95hf_ctx_t * ctx, bool fieldOn);

int cr95hf_checkId(cr95hf_ctx_t *ctx);
int cr95hf_getFnPtr(rfidGeneric_fnPtr_t *ptr);
#define CR95HF_SPI_SEND           0x00
#define CR95HF_SPI_RESET          0x01
#define CR95HF_SPI_READ           0x02
#define CR95HF_SPI_POLL           0x03

#define CR95HF_FLAG_DATA_PENDING (1 << 3)
#define CR95HF_FLAG_CMD_READY    (1 << 2)

#define CR95HF_TXFLAG_TOPAZ         (1 << 7)
#define CR95HF_TXFLAG_SPLIT_FRAME   (1 << 6)
#define CR95HF_TXFLAG_APPEND_CRC    (1 << 5)
#define CR95HF_TXFLAG_PARITY_FRAME  (1 << 4)


#define CR95HF_CMD_IDN            0x01
#define CR95HF_CMD_PROTOCOL_SEL   0x02
#define CR95HF_CMD_SEND_RECV      0x04
#define CR95HF_CMD_IDLE           0x07
#define CR95HF_CMD_REG_RD         0x08
#define CR95HF_CMD_REG_WR         0x09
#define CR95HF_CMD_SET_BAUDRATE   0x0A
#define CR95HF_CMD_SET_ECHO       0x55

#define CR95HF_RESULT_OK                  0x80
#define CR95HF_RESULT_E_FRAME_WAIT_T_OUT  0x87 //No response seen
#define CR95HF_RESULT_OK_RESIDUAL_BITS    0x90


#ifndef CR95HF_DEFAULT_RETRY_COUNT
  #define CR95HF_DEFAULT_RETRY_COUNT 20
#endif

#endif //CR95HF_H
