//Standard Error codes
//(C) TechnicallyObsolete 2016, 2017, 2020
#ifndef STANDARD_ERROR_H

/* Positive return values are number of bytes sent / read / written*/

#define ERR_OK			0
#define ERR_UNSPECIFIED		-1

#define ERR_BAD_PARAM		-5
#define ERR_BAD_PARAM_1         -6
#define ERR_BAD_PARAM_2         -7
#define ERR_BAD_PARAM_3         -8
#define ERR_BAD_PARAM_4         -9

#define ERR_TMEOUT_NO_ACK	-10	/* Read/write timed out */
#define ERR_TIMED_OUT     -11
#define ERR_NACK          -12
#define ERR_HARDWARE_FAULT	-15	/**/
#define ERR_DATAERROR		-20
#define ERR_BAD_CHECKSUM	-25	/* CRC or checksum didn't match*/
#define ERR_MSG_OVERLENGTH	-30	/*Data length was too long*/
#define ERR_DATA_VERIFYERR	-31	/*EEPROM or flash failed to verify*/
#define ERR_MSG_UNDERLENGTH     -32
#define ERR_BUFFER_FULL		-35	/*no space left in buffer*/
#define ERR_BUFFER_EMPTY	-40	/*Tried to get from buffer, but was empty*/
#define ERR_WRITE_PROTECT	-45	 
#define ERR_UNSUPPORTED_CMD	-50
#define ERR_UNSUPPORTED_ACT	-55

#define ERR_NOTFOUND            -60
#define ERR_DUPLICATE		        -65 
#define ERR_CHANNEL_BUSY        -70
#define ERR_FILE_COULD_NOT_OPEN -75
#define ERR_FILE_END            -76
  #define ERR_NOT_YET_IMPLEMENTED -80
  #define ERR_TRY_LATER -85
  #define ERR_MUTEX_LOCKED -90 /*I2C or SPI interface is locked by another thread*/
#define ERR_ASSERT_FAILED -100 //Internal software error
#define ERR_BAD_ADDR -105
#define ERR_NO_PRIV  -110

char const * errorCode_getStr(int code);
#endif /*STANDARD_ERROR_H*/
