//Standard Error codes
//(C) TechnicallyObsolete 2016, 2017, 2020

#include "error_codes.h"

char const * errorCode_getStr(int code){
  if (code >= 0){
    return "ERR_OK";
  }

  switch(code){
    case ERR_UNSPECIFIED: return "ERR_UNSPECIFIED";

    case ERR_BAD_PARAM: return "ERR_BAD_PARAM";
    case ERR_BAD_PARAM_1: return "ERR_BAD_PARAM_1";
    case ERR_BAD_PARAM_2: return "ERR_BAD_PARAM_2";
    case ERR_BAD_PARAM_3: return "ERR_BAD_PARAM_3";
    case ERR_BAD_PARAM_4: return "ERR_BAD_PARAM_4";

    case ERR_TMEOUT_NO_ACK: return "ERR_TMEOUT_NO_ACK";
    case ERR_TIMED_OUT:       return "ERR_TIMEOUT";
    case ERR_NACK:          return "ERR_NACK";
    case ERR_HARDWARE_FAULT: return "ERR_HARDWARE_FAULT";
    case ERR_DATAERROR: return "ERR_DATAERROR";
    case ERR_BAD_CHECKSUM: return "ERR_BAD_CHECKSUM";
    case ERR_MSG_OVERLENGTH: return "ERR_MSG_OVERLENGTH";
    case ERR_DATA_VERIFYERR: return "ERR_DATA_VERIFYERR";
    case ERR_MSG_UNDERLENGTH: return "ERR_MSG_UNDERLENGTH";
    case ERR_BUFFER_FULL: return "ERR_BUFFER_FULL";
    case ERR_BUFFER_EMPTY: return "ERR_BUFFER_EMPTY";
    case ERR_WRITE_PROTECT: return "ERR_WRITE_PROTECT";
    case ERR_UNSUPPORTED_CMD: return "ERR_UNSUPPORTED_CMD";
    case ERR_UNSUPPORTED_ACT: return "ERR_UNSUPPORTED_ACT";

    case ERR_NOTFOUND: return "ERR_NOTFOUND";
    case ERR_DUPLICATE: return "ERR_DUPLICATE";
    case ERR_CHANNEL_BUSY: return "ERR_CHANNEL_BUSY";
    case ERR_FILE_COULD_NOT_OPEN: return "ERR_FILE_COULD_NOT_OPEN";
    case ERR_FILE_END: return "ERR_FILE_END";
    case ERR_NOT_YET_IMPLEMENTED: return "ERR_NOT_YET_IMPLEMENTED";
    case ERR_TRY_LATER: return "ERR_TRY_LATER";
    case ERR_MUTEX_LOCKED: return "ERR_MUTEX_LOCKED";
    case ERR_ASSERT_FAILED: return "ERR_ASSERT_FAILED";
    default: return "ERR_????";
  }
}
