#ifndef FLASH_DCC_LOCO_DECODER_H
#define FLASH_DCC_LOCO_DECODER_H
#include <stdint.h>
#include <stdbool.h>


#define FLASH_DCC_LOCO_DECODER_HEADER_LEN 8
#define FLASH_DCC_LOCO_DECODER_CV_PER_CONFIG_BLOCK 24
#define FLASH_DCC_LOCO_DECODER_CV_WEAR_LEVEL 16

#define FLASH_DCC_LOCO_DECODER_ERASE_BLOCK_SIZE 4096

#define FLASH_DCC_LOCO_DECODER_CONFIG_BLOCK_LEN (FLASH_DCC_LOCO_DECODER_HEADER_LEN + FLASH_DCC_LOCO_DECODER_CV_PER_CONFIG_BLOCK)
#define FLASH_DCC_LOCO_DECODER_CONFIG_FAST_BLOCK_LEN (FLASH_DCC_LOCO_DECODER_HEADER_LEN + 1)


//Header Format
//[0] Type H
//[1] Type L
//[2] Length H
//[3] Length L

//For Type = 0x0100:
//[4] Addr H
//[5] Addr L
//[6] CRC-16 H
//[7] CRC-16 L


int flashDccLocoDecoder_cvLoadBulk(uint8_t target[256]);
int flashDccLocoDecoder_cvStore(uint8_t allCv[256], uint16_t cv, uint8_t newValue);
int flashDccLocoDecoder_cvLoadPage(uint8_t target[FLASH_DCC_LOCO_DECODER_CV_PER_CONFIG_BLOCK], uint16_t startCv);
int flashDccLocoDecoder_cvLoadFreqMod(uint8_t target[1], uint16_t cv);

int flashDccLocoDecoder_cvResetDefault(void);

#endif //FLASH_DCC_LOCO_DECODER_H
